<?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */
 
!defined('DL_Root') && exit ( 'Access Denied!' );

class DAr extends DDbBase{

	private $_dbar;

	private $_cache;

	private $_sql;

	private $_table;

	private $_pk;

	private $_isNew = false;

	private static $_field = array();
	
	private static $_cacheTime,$_pdoMode;

	public function __construct()
	{
		parent::__construct();
		$this->setNew(true);
		$this->_dbar = $this->returnDb();
		$this->_cache = $this->returnCache();
		$this->_arInit();
		$this->_getPdoCache();
	}

	public static function Model($className=__CLASS__)
	{
		return DuoLam::app($className);
	}

	private function _getPdoCache($params=array())
	{
		$methods = get_class_methods($this);
		if(in_array('setPdoCache', $methods))
		{
			$params = $this->setPdoCache();
		}
		self::$_cacheTime = empty($params['cacheTime']) ? 0 : $params['cacheTime'];
		self::$_pdoMode = empty($params['pdoMode']) ? PDO::FETCH_OBJ : $params['pdoMode'];
	}

	public function setNew($value)
	{
		$this->_isNew = $value;
	}

	public function getNew()
	{
		return $this->_isNew;
	}

	private function _arInit()
	{
		$methods = get_class_methods($this);
		if(in_array('tableName', $methods))
		{
			$this->_table = $this->tableName();
		}
		else
		{
			DEr::notice('继承Ar的模型没有指定数据表');
		}
		if(in_array('pimaryKey',$methods))
		{
			$this->_pk = $this->pimaryKey();
		}
		else
		{
			DEr::notice('继承Ar的模型没有指定字段主键');
		}
		$this->getField();
	}

	private function getField()
	{
		$sql = 'SHOW COLUMNS FROM '. $this->_table;
		self::$_field = $this->_fetch($sql,1);
	}

	private function setField()
	{
		foreach(self::$_field as $key =>$val)
		{
			if($this->_pk == $val['Field']) continue;
			$field[$val['Field']] = $val['Field'];
		}
		return $field;
	}

	public function getSql()
	{
		return self::setTableSuffix($this->_sql);
	}

	public function fetch($field='*',$where='',$other='')
	{
		$where = empty($where) ? $where : $where . ' AND ';
		$params = array(
			'field'=>$field,
			'where'=>$where,
			'other'=>$other
		);
		$this->options('S',$params);
		return $this->_fetch($this->_sql,0,self::$_cacheTime,self::$_pdoMode);
	}

	public function fetchAll($field='*',$where='',$other='')
	{
		$where = empty($where) ? $where : $where . ' AND ';
		$params = array(
			'field'=>$field,
			'where'=>$where,
			'other'=>$other
		);
		$this->options('S',$params);
		return $this->_fetch($this->_sql,1,self::$_cacheTime,self::$_pdoMode);
	}

	public function fetchByPk($id,$field='*',$where='',$other='')
	{
		$where = empty($where) ? $where : $where . ' AND ';
		$params = array(
			'field'=>$field,
			'where'=>$where .= $this->_pk.'='. $id .' AND ',
			'other'=>$other,
		);
		$this->options('S',$params);
		return $this->_fetch($this->_sql,0,self::$_cacheTime,self::$_pdoMode);
	}

	public function fetchAllByPk($id,$field='*',$where='',$other='')
	{
		$where = empty($where) ? $where : $where . ' AND ';
		$params = array(
			'field'=>$field,
			'where'=>$where .= $this->_pk.'='. $id .' AND ',
			'other'=>$other
		);
		$this->options('S',$params);
		return $this->_fetch($this->_sql,1,self::$_cacheTime,self::$_pdoMode);
	}

	public function updateByPk($id,$where='')
	{	
		if(!$this->getNew()) return false;
		$data = $this->_data(true);
		if(!$this->_isNull($data)) return false;
		$where = empty($where) ? $where : $where . ' AND ';
		$this->options('U',$params['where']=$where);
		$args = array(
			'table' => $this->_table,
			'field' => $data,
			'where' => $this->_pk.'='.$id.' AND '.$this->_sql,
		);
		return $this->_update($args);
	}

	public function updateAll($where='')
	{
		if($this->getNew()) return false;
		$data = $this->_data(true);
		if(!$this->_isNull($data)) return false;
		$where = empty($where) ? $where : $where . ' AND ';
		$this->options('U',$params['where']=$where);
		$args = array(
			'table' => $this->_table,
			'field' => $data,
			'where' => $this->_sql,
		);
		return $this->_update($args);
	}

	public function insert()
	{
		if(!$this->getNew()) return false;
		$data = $this->_data(true);
		if(!$this->_isNull($data)) return false;
		$args = array(
			'table'=>$this->_table,
			'field'=>$data,
		);

		$lastId = $this->_insert($args);
		$idName = $this->pimaryKey();
		$this->$idName = $lastId;
		$this->setNew(false);
		return $lastId;
	}

	private function _isNull($data)
	{
		$temp = $str = null;
		foreach($data as $v)
		{
			$temp .= $v;
		}
		$len = strlen(trim($temp));
		return $len == 0 ? false : true;
	}

	public function save()
	{
		$idName = $this->pimaryKey();
		return $this->getNew() ? $this->insert() : $this->updateByPk($idName);
	}

	public function deleteByPk($id,$where='')
	{
		$this->options('D',$params['where']=$where);
		$args = array(
			'table' => $this->_table,
			'where' => $this->_pk.'='.$id.' AND '.$this->_sql,
		);
		return $this->_delete($args);
	}

	public function deleteAll($where='')
	{
		$this->options('D',$params['where']=$where);
		$args = array(
			'table' => $this->_table,
			'where' => $where,
		);
		return $this->_delete($args);
	}

	public function count($where='')
	{
		if(empty($where))
		{
			$sql = empty($this->_sql) ? "SELECT " .$this->_pk ." FROM " . $this->_table : $this->_sql;
		}
		else
		{
			$sql = "SELECT " .$this->_pk ." FROM " . $this->_table . ' WHERE ' . $where;
		}
		return $this->rowCount($sql);
	}

	private function options($mode='S',$params=array())
	{
		switch($mode)
		{
			case 'S':
				$this->_sql = $this->select($this->getArgs($params,'select'));
				$this->_sql .= $this->where($this->getArgs($params,'where'));
				$this->_sql .= $this->other($this->getArgs($params,'other'));
			break;
			case 'U':
				$this->_sql = $this->where($this->getArgs($params,'where'),true);
			break;
			case 'I':
				return true;
			break;
			case 'D':
				$this->_sql = $this->where($this->getArgs($params,'where'),true);
			break;
		}
	}

	private function _data($ispk = false,$cname='')
	{
		$this->_varPost($cname);
		$field = $this->setField();
		foreach($field as $k => $v)
		{
			$data = array(
				$k => empty($this->$k) ? ' ' : $this->$k,
			);
		}
		if($ispk)
		{
			$pk = $this->pimaryKey();
			if($this->$pk) $data[$pk] = $this->$pk;
		}
		return $data;
	}

	private function _varPost($cname='')
	{
		if(is_array($_POST) && !empty($_POST))
		{
			$field = $this->setField();
			$id = $this->pimaryKey();
			$field[$id] = true;
			foreach($_POST as $k=> $v)
			{
				if($cname) $k = substr($k,strlen($cname));
				if(isset($field[$k]) && $field[$k] == $k)
				{
					$this->$k = $v;
				}
			}
			if(empty($this->$id)) $this->$id = null;
		}
	}

	public function setCache($time)
	{
		self::$_cacheTime = $time;
		return $this;
	}

	private function select($field)
	{
		$field = empty($field) ? '*' : $field;
		return 'SELECT '.$field.' FROM '.$this->_table;
	}

	private function where($where,$string=false)
	{
		$where = empty($where) ? '1=1' : $where.' 1=1 ';
		return $string ? $where :' WHERE '. $where;
	}

	private function other($other)
	{
		return $other;
	}

	private function getArgs($var,$key)
	{
		if(is_array($var))
		{
			return empty($var[$key]) ? '' : $var[$key];
		}
		else
		{
			return empty($var) ? '' : $var;
		}
	}

	public function clearCache()
	{
		return $this->_cache->del($this->_sql);
	}

	public function clearCacheAll()
	{
		$this->_cache->delAll();
	}

	public function className()
	{
		return __CLASS__.'_';
	}

}
?>